﻿/*
 i-net software provides programming examples for illustration only, without warranty
 either expressed or implied, including, but not limited to, the implied warranties
 of merchantability and/or fitness for a particular purpose. This programming example
 assumes that you are familiar with the programming language being demonstrated and
 the tools used to create and debug procedures. i-net software support professionals
 can help explain the functionality of a particular procedure, but they will not modify
 these examples to provide added functionality or construct procedures to meet your
 specific needs.
  
 © i-net software 1998-2013

*/
using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Drawing;
using System.Data;
using System.Linq;
using System.Text;
using System.Windows.Forms;
using Inet.Viewer.Data;

namespace Inet.Viewer.WinForms.Export
{
    /// <summary>
    /// Settings panel for PostScript export.
    /// </summary>
    public partial class PSSettingsControl : FormatSettingsControl
    {
        /// <summary>
        /// Creates the control.
        /// </summary>
        public PSSettingsControl()
        {
            InitializeComponent();
        }

        /// <inheritdoc />
        public override Bitmap Icon { get { return FormatResource.ps_48; } }

        /// <inheritdoc />
        public override string Label { get { return "PostScript"; } }

        /// <inheritdoc />
        public override string FileSuffix { get { return "ps"; } }

        /// <inheritdoc />
        public override void CollectExportParameters(Dictionary<string, string> exportParams)
        {
            exportParams[URLRenderData.ParameterExportFmt] = (string)Controls.OfType<RadioButton>().FirstOrDefault(r => r.Checked).Tag;
        }
    }
}
